/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.TickedWorldOperation;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreativeRaiderStructureHandler
extends CreativeStructureHandler {
    private Map<BlockPos, List<String>> map;
    private IColonyRaidEvent event;
    private int colonyId;

    public CreativeRaiderStructureHandler(World world, BlockPos pos, String structureName, PlacementSettings settings, boolean fancyPlacement, IColonyRaidEvent event, int colonyId) {
        super(world, pos, structureName, settings, fancyPlacement);
        TileEntity entity;
        CompoundNBT teData;
        this.getBluePrint().rotateWithMirror(settings.getRotation(), settings.getMirror(), world);
        this.event = event;
        this.colonyId = colonyId;
        BlockInfo info = this.getBluePrint().getBlockInfoAsMap().getOrDefault(this.getBluePrint().getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null && (teData = this.getBluePrint().getTileEntityData(pos, this.getBluePrint().getPrimaryBlockOffset())) != null && teData.func_74764_b("blueprintDataProvider") && (entity = TileEntity.func_235657_b_((BlockState)info.getState(), (CompoundNBT)info.getTileEntityData())) instanceof IBlueprintDataProvider) {
            entity.func_174878_a(pos);
            this.map = ((IBlueprintDataProvider)entity).getWorldTagPosMap();
        }
        if (this.map == null) {
            Log.getLogger().error("Raider spawned without matching blueprint data for it: " + structureName);
        }
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        super.triggerSuccess(pos, list, placement);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        if (this.getWorld().func_180495_p(worldPos).func_177230_c() == Blocks.field_150340_R && this.map != null) {
            List tags = this.map.getOrDefault(worldPos, Collections.emptyList());
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                String tag;
                switch (tag = (String)iterator.next()) {
                    case "normal": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getNormalRaiderType(), this.event, this.colonyId);
                        return;
                    }
                    case "archer": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getArcherRaiderType(), this.event, this.colonyId);
                        return;
                    }
                    case "boss": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getBossRaiderType(), this.event, this.colonyId);
                        return;
                    }
                }
            }
        }
    }

    public static Blueprint loadAndPlaceStructureWithRotation(World worldObj, @NotNull String name, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean fancyPlacement, int colonyId, IColonyRaidEvent event, @Nullable ServerPlayerEntity player) {
        try {
            CreativeRaiderStructureHandler structure = new CreativeRaiderStructureHandler(worldObj, pos, name, new PlacementSettings(mirror, rotation), fancyPlacement, event, colonyId);
            if (structure.hasBluePrint()) {
                StructurePlacer instantPlacer = new StructurePlacer((IStructureHandler)structure);
                Manager.addToQueue((TickedWorldOperation)new TickedWorldOperation(instantPlacer, (PlayerEntity)player));
            }
            return structure.getBluePrint();
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return null;
        }
    }
}

